/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.fmexcelerator;

import com.verdegraphics.fmexcelerator.CancelEvent;
import com.verdegraphics.fmexcelerator.CancelListener;
import com.verdegraphics.fmexcelerator.ProgressListener;
import com.verdegraphics.fmexcelerator.ProgressUpdateEvent;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class ProgressIndicatorDialog
extends JDialog
implements ProgressListener {
    private final JFrame parent;
    private final ArrayList<CancelListener> listeners;
    private JButton cancelButton;
    private JLabel currentOperationLabel;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JLabel progressPercentLabel;

    public ProgressIndicatorDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.listeners = new ArrayList();
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ProgressIndicatorDialog.this.dispose();
                for (CancelListener listener : ProgressIndicatorDialog.this.listeners) {
                    listener.cancelled(new CancelEvent(this));
                }
            }
        });
    }

    public void addCancelListener(CancelListener listener) {
        this.listeners.add(listener);
    }

    public void removeCancelListener(CancelListener listener) {
        this.listeners.remove(listener);
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.progressLabel = new JLabel();
        this.progressPercentLabel = new JLabel();
        this.currentOperationLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Processing...");
        this.setCursor(new Cursor(3));
        this.setModal(true);
        this.setResizable(false);
        this.progressBar.setString("x/y");
        this.progressBar.setStringPainted(true);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ProgressIndicatorDialog.this.cancelButtonMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProgressIndicatorDialog.this.cancelButtonMouseEntered(evt);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressIndicatorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.progressLabel.setText("Progress:");
        this.progressPercentLabel.setText("0%");
        this.currentOperationLabel.setText("currentOperation");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.progressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressPercentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 164, Short.MAX_VALUE).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addComponent(this.currentOperationLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.currentOperationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.progressLabel).addComponent(this.progressPercentLabel)).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        for (CancelListener listener : this.listeners) {
            listener.cancelled(new CancelEvent(this));
        }
    }

    private void cancelButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void cancelButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(3));
    }

    public void setCurrentProcessName(String processName) {
        this.currentOperationLabel.setText(processName);
    }

    @Override
    public void progressUpdated(ProgressUpdateEvent event) {
        this.currentOperationLabel.setText(event.getOperationName());
        this.progressBar.setValue(event.getProgress());
        this.progressBar.setString(event.getAmountDone() + "/" + event.getTotalAmountToDo());
        this.progressPercentLabel.setText(event.getProgress() + "%");
    }
}

