/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.vgenexcelerator;

import com.verdegraphics.vgenexcelerator.AboutDialog;
import com.verdegraphics.vgenexcelerator.CancelEvent;
import com.verdegraphics.vgenexcelerator.CancelListener;
import com.verdegraphics.vgenexcelerator.InstructionsDialog;
import com.verdegraphics.vgenexcelerator.ProgressIndicatorDialog;
import com.verdegraphics.vgenexcelerator.VGENFileChooser;
import com.verdegraphics.vgenexcelerator.VGENProcessor;
import com.verdegraphics.vgenexcelerator.XLSXFileChooser;
import com.verdegraphics.vgenexcelerator.XLSXFileFilter;
import com.verdegraphics.vgenexcelerator.XLSXFileWriter;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class VGENExceleratorGUI
extends JFrame
implements CancelListener {
    private static File vgenReport;
    private static ExecutorService executor;
    private static SwingWorker<Void, Void> worker;
    private static ProgressIndicatorDialog progressIndicator;
    private static volatile LinkedHashMap<String, List<Object[]>> data;
    private static Future<Object> result;
    private JButton aboutButton;
    private JLabel developerBylineLabel;
    private JButton instructionsButton;
    private JButton loadReportButton;
    private JLabel reportProcessorTitleLabel;
    private JButton saveXLSXButton;
    private JPanel titlePanel;

    public VGENExceleratorGUI() {
        this.initComponents();
        progressIndicator = new ProgressIndicatorDialog(this, true);
        progressIndicator.addCancelListener(this);
        executor = Executors.newSingleThreadExecutor();
        data = new LinkedHashMap();
    }

    private void displayErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    private void loadAndProcessVGENReportFile() {
        worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                VGENFileChooser fileChooser = new VGENFileChooser();
                int returnVal = fileChooser.showOpenDialog(VGENExceleratorGUI.this);
                if (returnVal != 0) {
                    return null;
                }
                vgenReport = fileChooser.getSelectedFile();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressIndicator.setVisible(true);
                    }
                });
                VGENExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    VGENProcessor processor = new VGENProcessor(vgenReport);
                    processor.addProgressListener(progressIndicator);
                    data.put(ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle").getString("vgenExcelerator"), (List)executor.submit(processor).get());
                }
                catch (IOException | InterruptedException | ExecutionException ex) {
                    VGENExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(0));
                    if (ex.getCause() instanceof InterruptedException) {
                        this.cancel(true);
                    }
                    VGENExceleratorGUI.this.displayErrorMessage(ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle").getString("error"), ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle").getString("errorReadingVGENReport"));
                    this.cancel(true);
                }
                progressIndicator.setVisible(false);
                VGENExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(0));
                if (this.isCancelled()) {
                    return null;
                }
                VGENExceleratorGUI.this.saveXLSXButton.setEnabled(true);
                return null;
            }
        };
        this.setCursor(Cursor.getPredefinedCursor(3));
        worker.execute();
    }

    private void generateAndSaveXLSXFile() {
        worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                String extension;
                XLSXFileChooser xlsxFileChooser = new XLSXFileChooser();
                File xlsxFile = null;
                String defaultFileName = "VGEN Report " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + ".xlsx";
                xlsxFileChooser.setSelectedFile(new File(defaultFileName));
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle").getString("saveFileConfidentialityWarning"), ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle").getString("warning"), 2);
                int returnVal = xlsxFileChooser.showSaveDialog(VGENExceleratorGUI.this);
                if (!(returnVal != 0 || (extension = XLSXFileFilter.getExtension(xlsxFile = xlsxFileChooser.getSelectedFile())) != null && extension.equalsIgnoreCase("xlsx"))) {
                    xlsxFile = new File(xlsxFile.getAbsolutePath() + ".xlsx");
                }
                if (xlsxFile == null) {
                    return null;
                }
                XLSXFileWriter writer = new XLSXFileWriter(data, xlsxFile);
                writer.addProgressListener(progressIndicator);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressIndicator.setVisible(true);
                    }
                });
                VGENExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    executor.submit(writer).get();
                    VGENExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (InterruptedException ex) {
                    this.cancel(true);
                }
                catch (ExecutionException ex) {
                    VGENExceleratorGUI.this.displayErrorMessage(ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle").getString("error"), ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle").getString("errorWritingFile") + String.format("%n", new Object[0]) + ex.getMessage());
                    this.cancel(true);
                }
                if (this.isCancelled()) {
                    return null;
                }
                VGENExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle").getString("xlsxFileWrittenSuccessfully"), ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle").getString("xlsxFileWrittenSuccessfullyTitle"), 1);
                System.exit(0);
                return null;
            }
        };
        this.setCursor(Cursor.getPredefinedCursor(3));
        worker.execute();
    }

    @Override
    public void cancelled(CancelEvent event) {
        executor.shutdownNow();
        executor = Executors.newSingleThreadExecutor();
        this.setCursor(Cursor.getPredefinedCursor(0));
        worker.cancel(true);
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.reportProcessorTitleLabel = new JLabel();
        this.developerBylineLabel = new JLabel();
        this.aboutButton = new JButton();
        this.loadReportButton = new JButton();
        this.instructionsButton = new JButton();
        this.saveXLSXButton = new JButton();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("com/verdegraphics/vgenexcelerator/Bundle");
        this.setTitle(bundle.getString("vgenExceleratorWindowTitle"));
        this.setLocationByPlatform(true);
        this.setMaximumSize(new Dimension(310, 158));
        this.setMinimumSize(new Dimension(310, 158));
        this.setResizable(false);
        this.reportProcessorTitleLabel.setFont(this.reportProcessorTitleLabel.getFont().deriveFont(this.reportProcessorTitleLabel.getFont().getStyle() | 1, this.reportProcessorTitleLabel.getFont().getSize() + 5));
        this.reportProcessorTitleLabel.setText(bundle.getString("vgenExcelerator"));
        this.developerBylineLabel.setFont(this.developerBylineLabel.getFont().deriveFont(this.developerBylineLabel.getFont().getStyle() | 2));
        this.developerBylineLabel.setText(bundle.getString("developedByline"));
        GroupLayout titlePanelLayout = new GroupLayout(this.titlePanel);
        this.titlePanel.setLayout(titlePanelLayout);
        titlePanelLayout.setHorizontalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(titlePanelLayout.createSequentialGroup().addComponent(this.reportProcessorTitleLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.developerBylineLabel, -1, -1, Short.MAX_VALUE));
        titlePanelLayout.setVerticalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(titlePanelLayout.createSequentialGroup().addComponent(this.reportProcessorTitleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.developerBylineLabel)));
        this.reportProcessorTitleLabel.getAccessibleContext().setAccessibleName("");
        this.reportProcessorTitleLabel.getAccessibleContext().setAccessibleDescription("");
        this.aboutButton.setText(bundle.getString("about"));
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VGENExceleratorGUI.this.aboutButtonActionPerformed(evt);
            }
        });
        this.loadReportButton.setText(bundle.getString("loadVGENReport..."));
        this.loadReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VGENExceleratorGUI.this.loadReportButtonActionPerformed(evt);
            }
        });
        this.instructionsButton.setText(bundle.getString("viewInstructions"));
        this.instructionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VGENExceleratorGUI.this.instructionsButtonActionPerformed(evt);
            }
        });
        this.saveXLSXButton.setText(bundle.getString("saveXLSX..."));
        this.saveXLSXButton.setEnabled(false);
        this.saveXLSXButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VGENExceleratorGUI.this.saveXLSXButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instructionsButton, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.aboutButton)).addComponent(this.loadReportButton, -1, -1, Short.MAX_VALUE).addComponent(this.saveXLSXButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titlePanel, -2, -1, -2).addComponent(this.aboutButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instructionsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadReportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveXLSXButton).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        AboutDialog dialog = new AboutDialog((Frame)this, true);
        dialog.setVisible(true);
    }

    private void instructionsButtonActionPerformed(ActionEvent evt) {
        InstructionsDialog dialog = new InstructionsDialog((Frame)this, true);
        dialog.setVisible(true);
    }

    private void loadReportButtonActionPerformed(ActionEvent evt) {
        this.loadAndProcessVGENReportFile();
    }

    private void saveXLSXButtonActionPerformed(ActionEvent evt) {
        this.generateAndSaveXLSXFile();
    }
}

